unit SelectCipherSuitesFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CheckLst,
  StreamSec.Mobile.StreamSecII;

type
  TfrmSelectCipherSuites = class(TFrame)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    clbBulkCipher: TCheckListBox;
    clbHashAlgorithm: TCheckListBox;
    clbKeyAgreement: TCheckListBox;
    clbSignature: TCheckListBox;
    procedure clbBulkCipherClickCheck(Sender: TObject);
    procedure clbHashAlgorithmClickCheck(Sender: TObject);
    procedure clbKeyAgreementClickCheck(Sender: TObject);
    procedure clbSignatureClickCheck(Sender: TObject);
  private
    fOptions: TTLSOptions;
    procedure SetOptions(const Value: TTLSOptions);
  protected
    procedure PopulateLists;
    procedure UpdateProperty(const aName: string; aValue: TCheckBoxState);
  public
    property Options: TTLSOptions read fOptions write SetOptions;
  end;

implementation

uses
  TypInfo;

{$R *.dfm}

const
  cBulkCipher = 'BulkCipher';
  cHashAlgorithm = 'HashAlgorithm';
  cKeyAgreement = 'KeyAgreement';
  cSignature = 'Signature';

{ TfrmSelectCipherSuites }

procedure TfrmSelectCipherSuites.clbBulkCipherClickCheck(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to (Sender as TCheckListBox).Count - 1 do begin
    UpdateProperty(cBulkCipher + (Sender as TCheckListBox).Items[I],(Sender as TCheckListBox).State[I]);
  end;
end;

procedure TfrmSelectCipherSuites.clbHashAlgorithmClickCheck(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to (Sender as TCheckListBox).Count - 1 do begin
    UpdateProperty(cHashAlgorithm + (Sender as TCheckListBox).Items[I],(Sender as TCheckListBox).State[I]);
  end;
end;

procedure TfrmSelectCipherSuites.clbKeyAgreementClickCheck(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to (Sender as TCheckListBox).Count - 1 do begin
    UpdateProperty(cKeyAgreement + (Sender as TCheckListBox).Items[I],(Sender as TCheckListBox).State[I]);
  end;
end;

procedure TfrmSelectCipherSuites.clbSignatureClickCheck(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to (Sender as TCheckListBox).Count - 1 do begin
    UpdateProperty(cSignature + (Sender as TCheckListBox).Items[I],(Sender as TCheckListBox).State[I]);
  end;
end;

procedure TfrmSelectCipherSuites.PopulateLists;
var
  I, lCount, lIdx: Integer;
  lProps: PPropList;
  lName: string;
  lVal: TPreference;
begin
  clbBulkCipher.Clear;
  clbHashAlgorithm.Clear;
  clbKeyAgreement.Clear;
  clbSignature.Clear;
  lCount := GetPropList(fOptions,lProps);
  for I := 0 to lCount - 1 do begin
    if lProps[I].PropType^ = TypeInfo(TPreference) then begin
      lVal := TPreference(GetOrdProp(fOptions,lProps[I].Name));
      lName := lProps[I].Name;
      if Pos(cBulkCipher,lName) = 1 then begin
        lIdx := clbBulkCipher.Items.Add(Copy(lName,1+Length(cBulkCipher),MaxInt));
        case lVal of
          prNotAllowed: clbBulkCipher.State[lIdx] := cbUnchecked;
          prAllowed: clbBulkCipher.State[lIdx] := cbGrayed;
          prPrefer: clbBulkCipher.State[lIdx] := cbChecked;
        end;
      end else if Pos(cHashAlgorithm,lName) = 1 then begin
        lIdx := clbHashAlgorithm.Items.Add(Copy(lName,1+Length(cHashAlgorithm),MaxInt));
        case lVal of
          prNotAllowed: clbHashAlgorithm.State[lIdx] := cbUnchecked;
          prAllowed: clbHashAlgorithm.State[lIdx] := cbGrayed;
          prPrefer: clbHashAlgorithm.State[lIdx] := cbChecked;
        end;
      end else if Pos(cKeyAgreement,lName) = 1 then begin
        lIdx := clbKeyAgreement.Items.Add(Copy(lName,1+Length(cKeyAgreement),MaxInt));
        case lVal of
          prNotAllowed: clbKeyAgreement.State[lIdx] := cbUnchecked;
          prAllowed: clbKeyAgreement.State[lIdx] := cbGrayed;
          prPrefer: clbKeyAgreement.State[lIdx] := cbChecked;
        end;
      end else if Pos(cSignature,lName) = 1 then begin
        lIdx := clbSignature.Items.Add(Copy(lName,1+Length(cSignature),MaxInt));
        case lVal of
          prNotAllowed: clbSignature.State[lIdx] := cbUnchecked;
          prAllowed: clbSignature.State[lIdx] := cbGrayed;
          prPrefer: clbSignature.State[lIdx] := cbChecked;
        end;
      end;
    end;
  end;
end;

procedure TfrmSelectCipherSuites.SetOptions(const Value: TTLSOptions);
begin
  fOptions := Value;
  PopulateLists;
end;

procedure TfrmSelectCipherSuites.UpdateProperty(const aName: string;
  aValue: TCheckBoxState);
begin
  case aValue of
    cbUnchecked: SetOrdProp(fOptions,aName,Ord(prNotAllowed));
    cbChecked: SetOrdProp(fOptions,aName,Ord(prPrefer));
    cbGrayed: SetOrdProp(fOptions,aName,Ord(prAllowed));
  end;
end;

end.
